//@doc      TABLE INL CORE
//@module   TABLE.INL - Table inline declarations |
//  
//  This file contains inline definitions for the table classes.
//      
//  Only very small members are selected for inline code.
//  See the class listing for a description of these functions.
//  
//@normal   Copyright <cp> 1996 Meta Four Software. All rights reserved.

/////////////////////////////////////////////////////////////////////////////
// c4_Bytes

d4_inline c4_Bytes::c4_Bytes ()
    : _contents (0), _size (0), _copy (false)
{
}

d4_inline c4_Bytes::~c4_Bytes ()
{
    _LoseCopy();
}
    
d4_inline const uchar* c4_Bytes::Contents() const
{
    return _contents;
}

d4_inline int c4_Bytes::Size() const
{
    return _size;
}

d4_inline void c4_Bytes::_LoseCopy()
{
    if (_copy)
        delete [] (char*) _contents;
}

/////////////////////////////////////////////////////////////////////////////
// c4_Column

d4_inline ulong c4_Column::Size() const
{
    return _size;
}

d4_inline void c4_Column::SetDirty()
{
    _position = 1;
}

d4_inline bool c4_Column::IsDirty() const
{
    return _position <= 1;
}

/////////////////////////////////////////////////////////////////////////////
// c4_Table
    
d4_inline c4_Persist* c4_Table::Persist() const
{
    return _persist;
}

d4_inline c4_Field& c4_Table::Definition() const
{
    return *_field;
}

d4_inline c4_Table& c4_Table::Owner() const
{
    return *_owner;
}

d4_inline int c4_Table::OwnerRow() const
{
    return _ownerRow;
}

d4_inline void c4_Table::SetOwnerRow(int row_)
{
    _ownerRow = row_;
}

d4_inline c4_Column& c4_Table::Column(int index_) const
{
    return *(c4_Column*) _columns.GetAt(index_);
}

d4_inline int c4_Table::NumColumns() const
{
    return _columns.GetSize();
}

d4_inline c4_HandlerSeq& c4_Table::Sequence()
{
    return *_sequence;
}

/////////////////////////////////////////////////////////////////////////////
